#
# This script exports a .xml file that can be used as a commandline parameter for the rrSubmitter / rrSubmitterconsole.
# Or you can start the rrSubmitter and use the load button 
#
# Please see help section "SDK/ Python reference / module rrJob"  for function descriptions.
#

import subprocess
import datetime
import os
import sys

exportFilename = rrGlobal.rrRootPath() + "inhouse/"
jobCount = rr.jobSelected_count()

joinSettings = True
exportAllSettings = False
lockSettings = False  # the user cannot change the settings


rrJob.exportJobAsXml_MultiStart()

for i in range(jobCount):
    selectedJob = rr.jobSelected_get(i)  # get a COPY of the job
    # Do some changes to the job if you like
    # Remember it is a copy and not the job in the RR queue.    
    rrJob.exportJobAsXml_MultiAdd(selectedJob, exportAllSettings)
    exportFilename = selectedJob.companyProjectRootFolder()


exportFilename += "job_SubmissionExport__" + datetime.datetime.now().strftime("%Y%m%d_%H%M%S")+".xml"
exportFilename = os.path.normpath(exportFilename)

result = -1
if not rrJob.exportJobAsXml_MultiEnd(exportFilename, joinSettings, lockSettings):
    rrGlobal.messageBox(rrGlobal.logLvL.warning, "Unable to write file "+exportFilename)
else:
    result = rrGlobal.messageBox(rrGlobal.logLvL.info, "Exported submission .xml file "+exportFilename,
                                 "Show Submission UI",
                                 "Submit Directly", True, 30)

if result != -1:
    submitter_path = rrGlobal.rrBinPath()
    submitter_name = ""
    if result == 1:
        submitter_name = "rrSubmitter"
    elif result == 0:
        submitter_name = "rrSubmitterconsole"

    submitter_path += submitter_name
    platform = sys.platform

    if platform.startswith("win"):
        submitter_path += ".exe"
    elif platform == "darwin":
        submitter_path += ".app/Contents/MacOS/"
        submitter_path += submitter_name

    if not os.path.isfile(submitter_path):
        rrGlobal.messageBox(rrGlobal.logLvL.warning, "Submitter not found: " + submitter_path)
    else:
        subprocess.Popen([submitter_path, exportFilename])
